#!/bin/sh

###############################################################################
#                                                                             #
# DESCRIPTION:	Setup an anonymous chroot enviroment                          #
# PATH:		./mk_chroot_dir.sh                                            #
# USAGE:	sh ./mk_chroot_dir.sh                                         #
# AUTHOR:	Norbert Eusterholz 'NE' <norbert@eusterholz.com>              #
#                                                                             #
# HISTORY:                                                                    #
# +------------+-----------------------------------------------------+------+ #
# | DATE       | CHANGES                                             | NAME | #
# +============+=====================================================+======+ #
# | 2004.05.19 | creation                                            | NE   | #
# +------------+-----------------------------------------------------+------+ #
#                                                                             #
###############################################################################

# create base-anon-dir: '/var/ftp' and user: 'ftp'
mkdir /var/ftp/
useradd -d /var/ftp ftp
chown root.root /var/ftp
chmod 555 /var/ftp

# create './bin' and copy required commands
mkdir /var/ftp/bin
chown root.root /var/ftp/bin
chmod 511 /var/ftp/bin
cp /bin/ls /var/ftp/bin/
cp /bin/tar /var/ftp/bin/
cp /bin/gzip /var/ftp/bin/
chmod 111 /var/ftp/bin/*

# create './dev' and null
mkdir /var/ftp/dev
chown root.root /var/ftp/dev
chmod 511 /var/ftp/dev
mknod /var/ftp/dev/null c 1 3
chmod 666 /var/ftp/dev/null

# create './etc' and copy required commands
mkdir /var/ftp/etc
chown root.root /var/ftp/etc
chmod 511 /var/ftp/etc
grep "root" /etc/passwd > /var/ftp/etc/passwd.tmp
grep "ftp" /etc/passwd >> /var/ftp/etc/passwd.tmp
sed -e 's/:[^:]*:/:*:/' /var/ftp/etc/passwd.tmp >/var/ftp/etc/passwd
rm /var/ftp/etc/passwd.tmp
grep "root" /etc/group > /var/ftp/etc/group
chmod 444 /var/ftp/etc/*
chown root.root /var/ftp/etc/*

# create './lib' and copy required commands
mkdir /var/ftp/lib
chown root.root /var/ftp/lib
chmod 511 /var/ftp/lib
cp `ldd /bin/ls | cut -d" " -f3` /var/ftp/lib/
cp `ldd /bin/tar | cut -d" " -f3` /var/ftp/lib/
cp `ldd /bin/gzip | cut -d" " -f3` /var/ftp/lib/
chmod 555 /var/ftp/lib/*
chown root.root /var/ftp/lib/*

# create './pub'
mkdir /var/ftp/pub
chown root.root /var/ftp/pub
chmod 555 /var/ftp/pub

# create './incomming'
mkdir /var/ftp/incomming
chown root.root /var/ftp/incomming
chmod 733 /var/ftp/incomming

# copy message-files
cp ./welcome.msg /var/ftp/
cp ./message /var/ftp/.message
cp ./HEADER /var/ftp/
cp ./README /var/ftp/
mkdir /var/ftp/msgs
chmod 511 /var/ftp/msgs
cp ./msg.dead /var/ftp/msgs/
cp ./welcome.msg /var/ftp/msgs/
cp ./HEADER_pub /var/ftp/pub/HEADER
cp ./README_pub /var/ftp/pub/README
